/*:
 * @target MZ
 * @plugindesc メッセージ位置強制固定プラグイン
 * @author ruke
 *
 * @help
 * このプラグインは、メッセージウィンドウの表示位置を
 * プラグインコマンドから一括で強制固定します。
 * * 「解除」するまでは、イベントコマンド側でどの位置（上・中・下）を
 * 選んでいても、設定した位置に固定されます。
 *
 * @command forcePosition
 * @text 位置を強制固定
 * @desc メッセージの表示位置を強制的に固定します。
 *
 * @arg position
 * @text 固定位置
 * @desc 固定する場所を選んでください。
 * @type select
 * @option 上
 * @value 0
 * @option 中
 * @value 1
 * @option 下
 * @value 2
 * @default 1
 *
 * @command clearForce
 * @text 強制固定を解除
 * @desc 位置の強制固定を解除し、通常の設定に戻します。
 */

(() => {
    const pluginName = "MessagePositionForcer";
    let forcedPosition = null;

    // 位置を強制するコマンド
    PluginManager.registerCommand(pluginName, "forcePosition", args => {
        forcedPosition = Number(args.position);
    });

    // 解除するコマンド
    PluginManager.registerCommand(pluginName, "clearForce", () => {
        forcedPosition = null;
    });

    const _Window_Message_updatePlacement = Window_Message.prototype.updatePlacement;
    Window_Message.prototype.updatePlacement = function() {
        _Window_Message_updatePlacement.call(this);

        // 強制指定がある場合のみ上書き
        if (forcedPosition !== null) {
            this._positionType = forcedPosition;
            // 座標の再計算（標準の計算式）
            this.y = (this._positionType * (Graphics.boxHeight - this.height)) / 2;
        }
    };
})();